; ===========================================================================
; ---------------------------------------------------------------------------
; Test ROM
; ---------------------------------------------------------------------------

		include "Z80 Language.asm"
		include	"Equates.asm"
		include	"Macros.asm"

; ===========================================================================
; ---------------------------------------------------------------------------
; Start of ROM data
; ---------------------------------------------------------------------------

StartRom:	dc.l	R_StackSP				; stack/VDP reg address
		moveq	#$00,d4					; clear d4
		ori.b	#.SetupList,d4				; a filler instruction, must be ori.b, must be d4 (The immediate value can be whatever necessary though).

	; --- TMSS ---

		movea.w	d4,a0					; set address of setup list
		movem.l	(a0)+,d2/d7/a2/a4-a6			; VDP reg counters, DMA write, control ports address, & VDP data and control ports
		movem.w	(a0)+,d0/d1/d5-d6/a3			; load number of entries, 80XX value, 0100 for advancing (and for Z80 later), VDP reg RAM
		and.b	-$07(a4),d0				; get only version number
		beq.s	.NoTMSS					; if it's version 0, branch
		move.l	(ConsoleName).w,($3FFF-$07)(a4)		; save SEGA to TMSS chip

	.NoTMSS:

	; --- VDP DMA wait/Latch reset ---

		move.w	(a6),ccr				; load status (this resets the 2nd write flag too)
		bvs.s	*-2					; if the VDP DMA busy flag was set (bit 1), branch to wait til finished...

	; --- VDP Register Setup & VRAM Clear ---

		lea	(sp),a1					; load beginning of VDP register RAM

	.NextVDP:
		addq.b	#(.DMAE-.DMAS)+1,d1			; increase count correctly for normal VDP registers/set size for DMA registers)

	.SetupVDP:
		move.w	d2,(a6)					; set VDP register
		move.w	d2,(a1)+				; ...and save to RAM storage
		add.w	d5,d2					; advance register ID
		move.b	(a0)+,d2				; load next register value
		subq.b	#$01,d1					; decrease register count (LOWER BYTE ONLY, Upper byte is needed for PSG mute counter)
		bpl.s	.SetupVDP				; if still counting, repeat
		move.w	a5,(a1)+				; clear "movep" pad slot / "word" bug slot
		add.w	d6,d2					; advance to DMA register slot/ID
		neg.w	d5					; reverse register increment direction
		bmi.s	.NextVDP				; if not positive, we haven't done DMA registers yet, so loop for them
		move.l	d7,(a6)					; set DMA fill destination
		move.w	a5,(a5)					; set DMA fill value (0000)

	; --- 68k RAM Clear ---

		move.l	(a3)+,a1 ; a1 = $8E008F01 (ROM 8F01)	; set to clear ROM space (just to waste time)
		tst.w	(a4)+					; has reset occurred? (i.e. port A been initialised already)
		bne.s	.ClearRAM				; if so, (fail to) clear ROM to waste CPU time for DMA fill
		lea	(sp),a1  ; a1 = $FFFFFFXX (RAM)		; set to clear RAM space instead

	.ClearRAM:
		sf.b	-(a1)					; clear RAM (fail to clear ROM to waste time)
		move.w	a1,d4					; have we reached 0000 yet?
		bne.s	.ClearRAM				; if not, continue until clear

	; --- Loading Z80 related data (for Part 2) ---

		; On power on, Z80 reset is apparently on, but on
		; soft reset it may be off, so might as well put
		; it on anyway to ensure YM2612 is reset if anything.

		lea	$11F6(a4),a1				; load Z80 BUS address area
		move.w	d5,-$100(a1)				; request Z80 stop (ON)
		move.w	a5,(a1)					; request Z80 reset (ON) (resets YM2612)

	; --- CRAM/VSRAM Clear ---

		lsr.b	#$03,d7					; move DMA bit to VSRAM address bit
		addq.w	#$01,-(a3)				; reset increment mode for 68k RAM
		move.w	(a3),(a6)				; '' (and now for VDP)

	.ClearCRAM:
		move.l	d7,(a6)					; set VDP to VSRAM write mode
		sf.b	d7					; set to clear $100 words (won't matter due to wrapping, but need to waste time to let Z80 finish reset)

	.ClearVSRAM:
		move.w	a5,(a5)					; clear VSRAM/CRAM (done by word to slow the 68k down enough to stop the Z80 in time)
		subq.b	#$01,d7					; decrease counter
		bne.s	.ClearVSRAM				; if not finished, loop and keep clearing
		move.w	d5,(a1)					; request Z80 reset (OFF) (CANNOT WRITE TO Z80 RAM WHILE RESET IS ON!  (I tried ;-;))
		move.b	(a0)+,(a2)+				; copy di/jp instruction to Z80 RAM
		neg.l	d7					; change address from VSRAM to CRAM
		bmi.s	.ClearCRAM				; if we're now writing to CRAM (negative $C0000000), then repeat for CRAM

; ---------------------------------------------------------------------------
; Setup information
; ---------------------------------------------------------------------------
;	 	align	$0070
; ---------------------------------------------------------------------------

		dc.w	%0100101011110000			; "tas.b $??(a0,??.?)" (should be "tas.b $06(a0,sp.l)")
		dc.w	(R_HBlankJmp&$FFFF)			; H-blank address
		swap	d7					; get $4000 in lower word for address checking with Z80
		bra.s	.Continue				; jump to part 2 code
		dc.l	R_VBlankJmp				; V-blank address

	.SetupList:
		dc.l	$00408000|%00000100		; d2	; control port init & 00LH 01CD - Leftover SMS bar (0N|1Y) | H-Interrupt (0N|1Y) | H,V Counter (0N|1Y) | Disable video signal (0N|1Y)
		dc.l	$40000080			; d7	; DMA Fill destination
		dc.l	$00A02000			; a2	; Z80 RAM address (mirror access 2000 to 4000)
		dc.l	$00A10008			; a4	; control ports (start on port A)
		dc.l	$00C00000			; a5	; VDP data port
		dc.l	$00C00004			; a6	; VDP control port

		dc.w	$000F				; d0
		dc.w	$FE00|(.VDPE-.VDPS)-(.DMAE-.DMAS) ; d1	; standard VDP register count (and upper byte for PSG mute counter)
		dc.w	$0100				; d5	; VDP Reg increment value & opposite initialisation flag for Z80
		dc.w	$0400				; d6	; for advancing VDP registers to start at last DMA reg
		dc.w	R_VDPReg8E&$FFFF		; a3	; RAM address where VDP auto-increment value is stored

	.VDPS:	dc.b	%00010100				; SDVM P100 - SMS mode (0N|1Y) | Display (0N|1Y) | V-Interrupt (0N|1Y) | DMA (0N|1Y) | V-resolution (0-1C|1-1E)
		dc.b	((($C000)>>$0A)&$FF)			; 00FE DCBA - Scroll Plane A Map Table VRam address
		dc.b	((($D000)>>$0A)&$FF)			; 00FE DCB0 / 00FE DC00 (20 Resolution) - Window Plane A Map Table VRam address
		dc.b	((($E000)>>$0D)&$FF)			; 0000 0FED - Scroll Plane B Map Table VRam address
		dc.b	((($B800)>>$09)&$FF)			; 0FED CBA9 / 0FED CBA0 (20 Resolution) - Sprite Plane Map Table VRam address
		dc.b	$00					; Unknown/Unused Register
		dc.b	$00					; 00PP CCCC - Backdrop Colour: Palette Line 0/Colour ID 0
		dc.b	$00					; Unknown/Unused Register
		dc.b	$00					; Unknown/Unused Register
		dc.b	$DF					; 7654 3210 - H-Interrupt Register
		dc.b	%00000100				; 0000 EVHH - External Interrupt (0N|1Y) | V-Scroll: (0-Full|1-2Celled) | H-Scroll: (00-Full|10-Celled|11-Sliced)
		dc.b	%10000001				; APHE SIIB - (AB) H-resol (0N|1Y) | Pixel int (0N|1Y) | H-sync (0N|1Y) | Extern-pix (0N|1Y) | S/H (0N|1Y) | Interlace (00N|01Y|11-Split) | (AB) H-resol (0-20|1-28)
		dc.b	((($BC00)>>$0A)&$FF)			; 00FE DCBA - Horizontal Scroll Table VRam address
		dc.b	$00					; Unknown/Unused Register
		dc.b	$01					; 7654 3210 - Auto Increment: By 1 (for DMA fill)
		dc.b	%00000001				; 00VV 00HH - Plane Y Size (00-20|01-40|11-80) | Plane X size (00-20|01-40|11-80)
		dc.b	$00					; 7654 3210 - Window Horizontal Position
	.VDPE:	dc.b	$00					; 7654 3210 - Window Vertical Position

	.DMAS:	dc.b	$80					; D654 3210 - DMA Fill Source (800000 Fill mode)
		dc.b	$00					; FEDC BA98 - ''
		dc.b	$00					; 7654 3210 - ''
		dc.b	$FF					; FEDC BA98 - DMA Fill Size (FFFF bytes)
	.DMAE:	dc.b	$FF					; 7654 3210 - ''

		dc.b	$40					; control port init 2

		dc.b	$F3,$C3					; di and jp instructions for Z80

; ---------------------------------------------------------------------------
; Continue (Part 2)
; ---------------------------------------------------------------------------

	.RunReset:
		jmp	(ResetGame).l				; jump to reset routine

	.Continue:

	; --- PSG Mute ---

		; d1 contains FEFF, the below will write all X7 and XF bytes
		; to the PSG, ensuring the last byte the PSG receives of each
		; channel is a volume of F (9F, BF, DF, and FF).
		; Hopefully it'll be quick enough that no tone is played...

	.MutePSG:
		move.b	d1,$0D(a6)				; mute PSG channel
		addq.w	#$08,d1					; advance up gradually to each PSG volume channel and force volume F
		bcc.s	.MutePSG				; if we haven't passed FF yet, loop

	; --- Z80 Setup ---


	.ClearZ80:
		move.b	d7,(a2)+				; clear Z80 space
		cmp.w	a2,d7					; have we reached end of Z80 RAM mirror?
		bne.s	.ClearZ80				; if we haven't, keep going...

	; --- ROM Checksum ---


		movea.w	a5,a2					; starting ROM address to checksum from
		; d7 contains $00004000, so the checksum value
		; must be +$00004000 too, no other registers are clear...

	.CheckSum:
		add.l	(a2)+,d7				; add a long-word of checksum
		sne.b	d0					; set d0 0000 or 00FF depending on sum being 0
		cmpa.l	(ROMFinish).w,a2			; have we passed the end of ROM address yet?
		bmi.s	.CheckSum				; if not, keep adding
		lsr.b	#$04,d0					; get only red
		move.w	d0,(a5)					; write backdrop colour
		bne.s	*					; if the colour wasn't black, loop endlessly

		move.w	a5,-$100(a1)				; request Z80 stop (OFF)

	; --- I/O port initialisation and jump to game code ---

		move.l	d2,(a4)					; initialise ports B and C
		tst.w	-(a4)					; has port A been initialised?  (i.e. are we resetting?)
		bne.s	.RunReset				; if so, run reset routine instead
		move.w	(a0),(R_MainJmp).w			; setup main routine "jmp" instruction
		move.w	(a0),(R_HBlankJmp).w			; setup H-blank "jmp" instruction
		move.w	(a0),(R_VBlankJmp).w			; setup V-blank "jmp" instruction
		move.w	d2,(a4)					; initialise port A (last one)
		jmp	(StartGame).l				; run normal power on routine

		dc.l	$00000000				; sum round up (account for +$00004000 in d7)

; ---------------------------------------------------------------------------
; Mega Drive specific data
; ---------------------------------------------------------------------------
;		align	$0100
; ---------------------------------------------------------------------------

ConsoleName:	dc.b	"SEGA MEGA DRIVE "
ProductDate:	dc.b	"(C)???? YYYY.MMM"
TitleLocal:	dc.b	"Engine Test                                     "
TitleInter:	dc.b	"Engine Test                                     "
SerialNumber:	dc.b	"GM XXXXXXXXXXX"
Checksum:	dc.w	$0000
IOSupport:	dc.b	"J               "
ROMStart:	dc.l	StartRom
ROMFinish:	dc.l	FinishRom-1
RAMStart:	dc.l	$00FF0000
RAMFinish:	dc.l	$00FFFFFF
SupportRAM:	dc.b	'    '		;'RA',%11111000,%00100000	; 1E1TT000 DDD0000 ; E = Erase (0 No | 1 Yes) TT = Type (00 both | 01 serial EEPROMS (RAMs with 4-bit data bus, etc...) | 10 even | 11 odd) DDD = Device type (001 SRAM | 010 EEPROM | rest unused)
SRAMStart:	dc.l	'    '		; $00200001
SRAMFinish:	dc.l	'    '		; $002001FF			; $00200001 (<- for modem)
SupportModem:	dc.b	"            "	; "MO*name*XX.YZZ   "
Notes:		dc.b	"                                        "
ProductRegion:	dc.b	"JUE             "

; ===========================================================================
; ---------------------------------------------------------------------------
; Start of game
; ---------------------------------------------------------------------------

ResetGame:
		move.l	#$C0000000,(a6)
		move.w	#$0E00,(a5)
		bra.w	*

StartGame:

	; --- Z80 ---

		lea	Z80(pc),a0					; load Z80 ROM data
		lea	($A00000).l,a1					; load Z80 RAM space address
		move.w	#(Z80_End-Z80)-$01,d1				; size of DualPCM
		move.w	#$0100,($A11100).l				; request Z80 stop (ON)
		move.w	#$0100,($A11200).l				; request Z80 reset (OFF)
		btst.b	#$00,($A11100).l				; has the Z80 stopped yet?
		bne.s	*-$08						; if not, branch

	.LoadZ80:
		move.b	(a0)+,(a1)+					; copy Dual PCM to Z80 RAM
		dbf	d1,.LoadZ80					; repeat til done

		move.w	#$0000,($A11200).l				; request Z80 reset (ON)
		moveq	#$7F,d1						; set delay time
		dbf	d1,*						; no way of checking for reset, so a manual delay is necessary
		move.w	#$0000,($A11100).l				; request Z80 stop (OFF)
		move.w	#$0100,($A11200).l				; request Z80 reset (OFF)

	; --- Loop ---

	.Next:
		sf.b	($00FF7FFF).l

		move.l	#$C0000000,(a6)
		move.w	#$0808,(a5)

	.Wait:	tst.b	($00FF7FFF).l
		beq.s	.Wait

		move.l	#$C0000000,(a6)
		move.w	#$00E0,(a5)

	.NoStart:
		bsr.s	ReadJoypads
		tst.b	($FFFFF605).w
		bpl.s	.NoStart


		move.w	#$0100,($A11100).l				; request Z80 stop (ON)
		btst.b	#$00,($A11100).l				; has the Z80 stopped yet?
		bne.s	*-$08						; if not, branch
		move.b	#$01,($A01FFF).l
		move.w	#$0000,($A11100).l				; request Z80 stop (OFF)

		bra.w	.Next



ReadJoypads:
		lea	($FFFFF604).w,a0 ; address where joypad	states are written
		lea	($A10003).l,a1	; first	joypad port
		bsr.s	Joypad_Read	; do the first joypad
		addq.w	#2,a1		; do the second	joypad

Joypad_Read:
		move.b	#0,(a1)
		nop	
		nop	
		move.b	(a1),d0
		lsl.b	#2,d0
		andi.b	#$C0,d0
		move.b	#$40,(a1)
		nop	
		nop	
		move.b	(a1),d1
		andi.b	#$3F,d1
		or.b	d1,d0
		not.b	d0
		move.b	(a0),d1
		eor.b	d0,d1
		move.b	d0,(a0)+
		and.b	d0,d1
		move.b	d1,(a0)+
		rts	



; ===========================================================================
; ---------------------------------------------------------------------------
; GSM 6.10 Z80 driver - MarkeyJester
; ---------------------------------------------------------------------------

Z80:		z80prog 0
		include	"Z80.asm"
		z80prog
Z80_End:

; ===========================================================================
; ---------------------------------------------------------------------------
; GSM Test sample
; ---------------------------------------------------------------------------

		align	$8000

GSM_Sample:	incbin	"Sample.gsm"
		even

; ===========================================================================




		align	$04					; must align to the next long-word (for checksum)
FinishRom:


